#!/usr/bin/env python3
from pathlib import Path
import sys; sys.path.append(str(Path(__file__).parent.parent.resolve()))

from manual_sweep import create_sweep


if __name__ == '__main__':
    import sys
    this_file_name = sys.argv[0]

    # Variables to sweep over
    envs = ['Cheetah-run', 'Walker-walk', 'Pendulum-swingup', 'Cartpole-swingup']
    env2experts_list = {
        'Cheetah-run': [[100], [100, 70], [100, 70, 40], [100, 70, 40, 20]],
        'Walker-walk': [[190, 150, 100, 80], [150, 100, 80, 50], [130, 100, 80, 40]],
        'Pendulum-swingup': [[200], [200, 150], [200, 150, 100], [200, 150, 100, 50], [200], [150], [100], [50]],
        'Cartpole-swingup': [[400, 300, 200, 40], [400, 140, 80], [400, 160, 60]]
    }
    env2ase_sigma = {
        'Cheetah-run': 2.5,
        'Walker-walk': 10,
        'Pendulum-swingup': 0.25,
        'Cartpole-swingup': 0.25,  # <-- We should run a sweep to find out a good value for this
    }

    seeds = [i for i in range(3)]
    learner_pis = ['rollin', 'rollin']
    algorithms = ['lops-aps', 'lops-aps-ase']

    fname = Path(this_file_name).stem + '.jsonl'
    create_sweep(fname, envs, env2experts_list, env2ase_sigma, algorithms, learner_pis, seeds)
